# Set-ExecutionPolicy RemoteSigned

# Run the PowerShell Script in Administrator Mode
if (!([Security.Principal.WindowsPrincipal][Security.Principal.WindowsIdentity]::GetCurrent()).IsInRole([Security.Principal.WindowsBuiltInRole]::Administrator)) {
    Start-Process PowerShell -Verb RunAs "-NoProfile -ExecutionPolicy Bypass -Command `"cd '$pwd'; & '$PSCommandPath';`"";
    exit;
}

try {
    # Make sure Powershell Execution Policy is bypassed to run the following script
    Set-ExecutionPolicy Bypass -Scope Process
    # Set-ExecutionPolicy RemoteSigned
}
catch {
    # echo "Error occurred when bypassing Powershell Execution Policy: $_"
    Start-Sleep -Seconds 60
}

$TCP_Port_of_IPAll = "1433"
$SQL_Server_Version = "SQL Server 2012"
$smo = 'Microsoft.SqlServer.Management.Smo.'
$SQL_Server_Version_Query_Output=sqlcmd -S .\SQLEXPRESS -Q "select @@version"

try {
    switch -Wildcard ($SQL_Server_Version_Query_Output)
    {
        "*SQL Server 2012*" { $SQL_Server_Version = "SQL Server 2012"; Break }
        "*SQL Server 2014*" { $SQL_Server_Version = "SQL Server 2014"; Break }
        "*SQL Server 2016*" { $SQL_Server_Version = "SQL Server 2016"; Break }
        "*SQL Server 2017*" { $SQL_Server_Version = "SQL Server 2017"; Break }
        "*SQL Server 2019*" { $SQL_Server_Version = "SQL Server 2019"; Break }
        "*SQL Server 2022*" { $SQL_Server_Version = "SQL Server 2022"; Break }
    }
}
catch {
    # echo "Error occurred when retrieving and appending environmental variable of PSModulePath: $_"
    Start-Sleep -Seconds 60
}

# echo "Before Appending Environment PSModulePath: $env:PSModulePath"
echo "PSScriptRoot: $PSScriptRoot" 
echo "SQL Server Version Query Output: $SQL_Server_Version_Query_Output" 
echo "\nSQL Server Version: $SQL_Server_Version" 

Start-Sleep -Seconds 6
# Stop SQLEXPRESS SQL Server Service before enabling TCP/IP Server Protocol
stop-service -Name 'MSSQL$SQLEXPRESS'
$regedit_argument = '/s "' + $PSScriptRoot + "\Change_Authentication_To_Dual_Modes_";
try {
    switch ($SQL_Server_Version) 
    {
        "SQL Server 2012" {
            $regedit_argument = $regedit_argument + "SQL_Server_2012.reg";
            Set-Itemproperty -path 'HKLM:SOFTWARE\WOW6432Node\Microsoft\Microsoft SQL Server\MSSQL11.SQLEXPRESS\MSSQLServer' -Name 'LoginMode' -value 2;
            Set-Itemproperty -path 'HKLM:SOFTWARE\WOW6432Node\Microsoft\Microsoft SQL Server\MSSQL11.SQLEXPRESS\MSSQLServer\SuperSocketNetLib\Tcp' -Name 'Enabled' -value 1;
            Set-Itemproperty -path 'HKLM:SOFTWARE\WOW6432Node\Microsoft\Microsoft SQL Server\MSSQL11.SQLEXPRESS\MSSQLServer\SuperSocketNetLib\Tcp\IPAll' -Name 'TcpPort' -value '1433';
            if ($env:PSModulePath -NotMatch "Microsoft SQL Server\\110") {
                $env:PSModulePath = $env:PSModulePath + ";C:\Program Files (x86)\Microsoft SQL Server\110\Tools\PowerShell\Modules";
                echo "After Appending Environment PSModulePath: $env:PSModulePath";
            }
            Break
        }
        "SQL Server 2014" {
            $regedit_argument = $regedit_argument + "SQL_Server_2014.reg";
            Set-Itemproperty -path 'HKLM:SOFTWARE\Microsoft\Microsoft SQL Server\MSSQL12.SQLEXPRESS\MSSQLServer' -Name 'LoginMode' -value 2;
            Set-Itemproperty -path 'HKLM:SOFTWARE\Microsoft\Microsoft SQL Server\MSSQL12.SQLEXPRESS\MSSQLServer\SuperSocketNetLib\Tcp' -Name 'Enabled' -value 1;
            Set-Itemproperty -path 'HKLM:SOFTWARE\Microsoft\Microsoft SQL Server\MSSQL12.SQLEXPRESS\MSSQLServer\SuperSocketNetLib\Tcp\IPAll' -Name 'TcpPort' -value '1433';
            if ($env:PSModulePath -NotMatch "Microsoft SQL Server\\120") {
                $env:PSModulePath = $env:PSModulePath + ";C:\Program Files (x86)\Microsoft SQL Server\120\Tools\PowerShell\Modules";
                echo "After Appending Environment PSModulePath: $env:PSModulePath";
            }
            Break
        }
        "SQL Server 2016" {      
            $regedit_argument = $regedit_argument + "SQL_Server_2016.reg";
            Set-Itemproperty -path 'HKLM:SOFTWARE\Microsoft\Microsoft SQL Server\MSSQL13.SQLEXPRESS\MSSQLServer' -Name 'LoginMode' -value 2;
            Set-Itemproperty -path 'HKLM:SOFTWARE\Microsoft\Microsoft SQL Server\MSSQL13.SQLEXPRESS\MSSQLServer\SuperSocketNetLib\Tcp' -Name 'Enabled' -value 1;
            Set-Itemproperty -path 'HKLM:SOFTWARE\Microsoft\Microsoft SQL Server\MSSQL13.SQLEXPRESS\MSSQLServer\SuperSocketNetLib\Tcp\IPAll' -Name 'TcpPort' -value '1433';
            if ($env:PSModulePath -NotMatch "Microsoft SQL Server\\130") {
                $env:PSModulePath = $env:PSModulePath + ";C:\Program Files (x86)\Microsoft SQL Server\130\Tools\PowerShell\Modules";
                echo "After Appending Environment PSModulePath: $env:PSModulePath";
            }
            Break
        }
        "SQL Server 2017" {
            $regedit_argument = $regedit_argument + "SQL_Server_2017.reg";
            Set-Itemproperty -path 'HKLM:SOFTWARE\Microsoft\Microsoft SQL Server\MSSQL14.SQLEXPRESS\MSSQLServer' -Name 'LoginMode' -value 2;
            Set-Itemproperty -path 'HKLM:SOFTWARE\Microsoft\Microsoft SQL Server\MSSQL14.SQLEXPRESS\MSSQLServer\SuperSocketNetLib\Tcp' -Name 'Enabled' -value 1;
            Set-Itemproperty -path 'HKLM:SOFTWARE\Microsoft\Microsoft SQL Server\MSSQL14.SQLEXPRESS\MSSQLServer\SuperSocketNetLib\Tcp\IPAll' -Name 'TcpPort' -value '1433';
            if ($env:PSModulePath -NotMatch "Microsoft SQL Server\\140") {
                $env:PSModulePath = $env:PSModulePath + ";C:\Program Files (x86)\Microsoft SQL Server\140\Tools\PowerShell\Modules";
                echo "After Appending Environment PSModulePath: $env:PSModulePath";
            }
            Break
        }
        "SQL Server 2019" {
            $regedit_argument = $regedit_argument + "SQL_Server_2019.reg";
            Set-Itemproperty -path 'HKLM:SOFTWARE\Microsoft\Microsoft SQL Server\MSSQL15.SQLEXPRESS\MSSQLServer' -Name 'LoginMode' -value 2;
            Set-Itemproperty -path 'HKLM:SOFTWARE\Microsoft\Microsoft SQL Server\MSSQL15.SQLEXPRESS\MSSQLServer\SuperSocketNetLib\Tcp' -Name 'Enabled' -value 1;
            Set-Itemproperty -path 'HKLM:SOFTWARE\Microsoft\Microsoft SQL Server\MSSQL15.SQLEXPRESS\MSSQLServer\SuperSocketNetLib\Tcp\IPAll' -Name 'TcpPort' -value '1433';
            if ($env:PSModulePath -NotMatch "Microsoft SQL Server\\150") {
                $env:PSModulePath = $env:PSModulePath + ";C:\Program Files (x86)\Microsoft SQL Server\150\Tools\PowerShell\Modules";
                echo "After Appending Environment PSModulePath: $env:PSModulePath";
            }
            Break
        }
        "SQL Server 2022" {
            $regedit_argument = $regedit_argument + "SQL_Server_2022.reg";
            Set-Itemproperty -path 'HKLM:SOFTWARE\Microsoft\Microsoft SQL Server\MSSQL16.SQLEXPRESS\MSSQLServer' -Name 'LoginMode' -value 2;
            Set-Itemproperty -path 'HKLM:SOFTWARE\Microsoft\Microsoft SQL Server\MSSQL16.SQLEXPRESS\MSSQLServer\SuperSocketNetLib\Tcp' -Name 'Enabled' -value 1;
            Set-Itemproperty -path 'HKLM:SOFTWARE\Microsoft\Microsoft SQL Server\MSSQL16.SQLEXPRESS\MSSQLServer\SuperSocketNetLib\Tcp\IPAll' -Name 'TcpPort' -value '1433';
            if ($env:PSModulePath -NotMatch "Microsoft SQL Server\\160") {
                $env:PSModulePath = $env:PSModulePath + ";C:\Program Files (x86)\Microsoft SQL Server\160\Tools\PowerShell\Modules";
                echo "After Appending Environment PSModulePath: $env:PSModulePath";
            }
            Break
        }
    }
}
catch {
    # echo "Error occurred when retrieving and appending environmental variable of PSModulePath: $_"
    Start-Sleep -Seconds 60
}

try {
    Start-Process "regedit.exe" $regedit_argument -NoNewWindow -Wait;
}
catch {
    
}

# Restart SQLEXPRESS SQL Server Service
start-service -Name 'MSSQL$SQLEXPRESS'
# Start-Sleep -Seconds 30
# echo "import sqlps module"
# Import SQLPS module to launch the SQL PowerShell in a command prompt
#Import-Module "sqlps"
#Start-Sleep -Seconds 20
# Initialize the Microsoft.SqlServer.Management.Smo namespace that contains the classes representing the core SQL Server database engine objects
#$smo = 'Microsoft.SqlServer.Management.Smo.'
# Set the ManagedComputer object that represents a Windows Management Instrumentation (WMI) installation on an instance of Microsoft SQL Server
#$wmi = new-object ($smo + 'Wmi.ManagedComputer')
# Stop SQLEXPRESS SQL Server Service before enabling TCP/IP Server Protocol
#stop-service -Name 'MSSQL$SQLEXPRESS'
# Find the Tcp Protocol settings
#$uri = "ManagedComputer[@Name='" + (get-item env:\computername).Value + "']/ServerInstance[@Name='SQLEXPRESS']/ServerProtocol[@Name='Tcp']"
#echo $uri
#$Tcp = $wmi.GetSmoObject($uri)
#echo $Tcp
# Enable TCP-IP
#$Tcp.IsEnabled = $true
# Validate the change by calling Alter method of Tcp variable
#$Tcp.Alter()
# Set the TCP Port of IPAll to 1433
#$wmi.GetSmoObject($uri + "/IPAddress[@Name='IPAll']").IPAddressProperties[1].Value="1433"
#$Tcp.Alter()

# Restart SQLEXPRESS SQL Server Service
# start-service -Name 'MSSQL$SQLEXPRESS'
# Start-Sleep -Seconds 12